/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.LogWriter;
import noppes.npcs.util.ValueUtil;

public class AddedPartConfig {
    public ResourceLocation location;
    public ResourceLocation objUp;
    public ResourceLocation objDown;
    public int parentPart = -1;
    public int id;
    public int textureU = 40;
    public int textureV = 16;
    public boolean isNormal;
    public final float[] pos = new float[]{0.0f, 0.0f, 0.0f};
    public final float[] rot = new float[]{0.0f, 0.0f, 0.0f};
    public final float[] size = new float[]{4.0f, 5.5f, 3.5f, 3.0f, 4.0f};

    public AddedPartConfig() {
        this.clear();
    }

    public AddedPartConfig(int parentPartId) {
        this.parentPart = parentPartId;
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = 0.0f;
            this.rot[i] = 0.0f;
        }
        this.size[0] = 4.0f;
        this.size[1] = 5.5f;
        this.size[2] = 3.5f;
        this.size[3] = 3.0f;
        this.size[4] = 4.0f;
        this.isNormal = true;
        this.textureU = 40;
        this.textureV = 16;
        this.location = new ResourceLocation("customnpcs", "textures/entity/humanmale/steve.png");
        this.objUp = null;
        this.objDown = null;
    }

    public void load(NBTTagCompound compound) {
        this.parentPart = compound.func_74762_e("ParentPart");
        this.location = new ResourceLocation(compound.func_74779_i("Location"));
        if (compound.func_150297_b("OBJUpLocation", 8)) {
            this.objUp = new ResourceLocation(compound.func_74779_i("OBJUpLocation"));
        }
        if (compound.func_150297_b("OBJDownLocation", 8)) {
            this.objUp = new ResourceLocation(compound.func_74779_i("OBJDownLocation"));
        }
        for (int i = 0; i < 5; ++i) {
            try {
                this.size[i] = ValueUtil.correctFloat(compound.func_150295_c("BaseSize", 5).func_150308_e(i), -1.0f, 1.0f);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (i > 2) continue;
            try {
                this.pos[i] = ValueUtil.correctFloat(compound.func_150295_c("BasePosition", 5).func_150308_e(i), -1.0f, 1.0f);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            try {
                this.rot[i] = ValueUtil.correctFloat(compound.func_150295_c("BaseRotation", 5).func_150308_e(i), -5.0f, 5.0f);
                continue;
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ParentPart", this.parentPart);
        compound.func_74778_a("Location", this.location.toString());
        if (this.objUp != null) {
            compound.func_74778_a("OBJUpLocation", this.objUp.toString());
        }
        if (this.objDown != null) {
            compound.func_74778_a("OBJDownLocation", this.objDown.toString());
        }
        NBTTagList listPos = new NBTTagList();
        NBTTagList listRot = new NBTTagList();
        NBTTagList listSize = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            listSize.func_74742_a((NBTBase)new NBTTagFloat(this.size[i]));
            if (i > 2) continue;
            listPos.func_74742_a((NBTBase)new NBTTagFloat(this.pos[i]));
            listRot.func_74742_a((NBTBase)new NBTTagFloat(this.rot[i]));
        }
        compound.func_74782_a("BasePosition", (NBTBase)listPos);
        compound.func_74782_a("BaseRotation", (NBTBase)listRot);
        compound.func_74782_a("BaseSize", (NBTBase)listSize);
        return compound;
    }
}

